/*
 *
 * Okna dialogowe
 *
 */
#include <windows.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
BOOL DialogBoxWindowProcedure(HWND, UINT, WPARAM, LPARAM);
void CreateMyMenu( HWND hwnd );
/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpszArgument, int nFunsterStil)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj 
                                              // obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0,                   
           szClassName,         
           "Przykad",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT,       
           CW_USEDEFAULT,       
           512,                 
           512,                 
           HWND_DESKTOP,        
           NULL,                
           hThisInstance,       
           NULL                 
           );

    CreateMyMenu( hwnd );
    ShowWindow(hwnd, nFunsterStil);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}

/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    static HINSTANCE hInstance ;

    switch (message)                  
    {
           case WM_CREATE :
                hInstance = ((LPCREATESTRUCT) lParam)->hInstance ;
                break;  
           case WM_DESTROY:
                PostQuitMessage(0);        
                break;
           case WM_COMMAND:
                switch(LOWORD(wParam))
                {
                     case 100 : DialogBox( hInstance, MAKEINTRESOURCE(501), 
                                  hwnd, DialogBoxWindowProcedure ); break;
                     case 101 : SendMessage( hwnd, WM_CLOSE, 0, 0 );break;
                }   
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}

void CreateMyMenu( HWND hwnd )
{
    HMENU hMenu;
    HMENU hSubMenu;

    hMenu = CreateMenu () ;

    hSubMenu = CreateMenu () ;
    AppendMenu (hSubMenu, MF_STRING   , 100, "&Okno dialogowe") ;
    AppendMenu (hSubMenu, MF_SEPARATOR, 0  , NULL) ;
    AppendMenu (hSubMenu, MF_STRING   , 101, "&Koniec") ;
    AppendMenu (hMenu, MF_POPUP, (unsigned int)hSubMenu, "&Plik") ;

    SetMenu( hwnd, hMenu );
}

BOOL DialogBoxWindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    switch (message)                  
    {
           case WM_INITDIALOG:
              return TRUE ;
           case WM_COMMAND : 
              switch (LOWORD (wParam))
              {
                 case IDOK : case IDCANCEL :
                 EndDialog (hwnd, 0) ;
                 return TRUE ;
              }
    }
    return 0;
}
